/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.util;

import com.ibm.hwmca.fw.util.Trace;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.util.FastHttpDateFormat;

public class ETagManager {
    public static final String TRACE_MASKT = "SFILETAT";
    public static final String TRACE_MASKF = "SFILETAF";
    public static final long FUTURE_EXPIRATION_IN_MS = 3600000L;
    private static ETagManager eTagManager = null;
    private String started = "\"" + Long.toHexString(System.currentTimeMillis()) + ":";
    private Map database = new HashMap();
    private int nextEtagValue = 0;

    public static final synchronized ETagManager getETagManager() {
        if (eTagManager == null) {
            eTagManager = new ETagManager();
        }
        return eTagManager;
    }

    private ETagManager() {
    }

    public synchronized String createETag(String url) {
        if (!this.database.containsKey(url)) {
            this.database.put(url, this.started + Integer.toHexString(this.nextEtagValue++) + "\"");
        }
        return (String)this.database.get(url);
    }

    public boolean handleRequest(ServletRequest request, ServletResponse response) {
        String inmHeader;
        if (request instanceof HttpServletRequest && (inmHeader = ((HttpServletRequest)request).getHeader("If-None-Match")) != null && ETagManager.getETagManager().eTagMatches(inmHeader, ((HttpServletRequest)request).getRequestURI())) {
            ((HttpServletResponse)response).addHeader("Expires", FastHttpDateFormat.getDate((Date)new Date(System.currentTimeMillis() + 3600000L)));
            ((HttpServletResponse)response).setStatus(304);
            return true;
        }
        return false;
    }

    public synchronized boolean eTagMatches(String eTag, String url) {
        Trace.trace(TRACE_MASKT, "ETagManager.eTagMatches('" + eTag + "', '" + url + "')");
        return this.database.containsKey(url) && this.database.get(url).equals(eTag);
    }

    public synchronized void clearETag(String url) {
        this.database.remove(url);
    }

    public synchronized void clearAllETags() {
        this.database.clear();
    }
}

